/*
 * This example shows how drive a GPIO as an output.
 */

#include <rt/rt_data.h>
#include <stdio.h>
#include <rt/rt_api.h>
#include <rt/rt_gpio.h>
#include <rt/chips/rt_wolfe.h>
#include <rt/rt_pad.h>
#include <stdint.h>
#include "vl53l1x.h"


#define MULTIRANGER_XSHUT_UP 0
#define MULTIRANGER_XSHUT_FRONT 1
#define MULTIRANGER_XSHUT_LEFT 3
#define MULTIRANGER_XSHUT_RIGHT 2
#define MULTIRANGER_XSHUT_BACK 6
#define MULTIRANGER_XSHUT_ALL (1<<MULTIRANGER_XSHUT_UP) || (1<<MULTIRANGER_XSHUT_FRONT) || (1<<MULTIRANGER_XSHUT_LEFT) || (1<<MULTIRANGER_XSHUT_RIGHT) || (1<<MULTIRANGER_XSHUT_BACK)

#define MULTIRANGER_XSHUT_LOW(PIN) rt_gpio_set_pin_value(0, PIN, 0)
#define MULTIRANGER_XSHUT_HIGH(PIN) rt_gpio_set_pin_value(0, PIN, 1)

static VL53L1_Dev_t devFront;
static VL53L1_Dev_t devLeft;
static VL53L1_Dev_t devRight;
static VL53L1_Dev_t devBack;
static VL53L1_Dev_t devUp;
static rt_i2c_t *i2c_conf;


// Inits the Padframe to use the GPIO and I2C Pins
int init_padframe()
{
  rt_pad_set_function(PAD_0_SPIM_SDIO0, PAD_0_FUNC1_GPIOA0);
  rt_pad_set_function(PAD_1_SPIM_SDIO1, PAD_1_FUNC1_GPIOA1);
  rt_pad_set_function(PAD_2_SPIM_SDIO2, PAD_2_FUNC1_GPIOA2);
  rt_pad_set_function(PAD_3_SPIM_SDIO3, PAD_3_FUNC1_GPIOA3);
  rt_pad_set_function(PAD_6_SPIM_SCK,   PAD_6_FUNC1_GPIOA6);
  rt_pad_set_function(PAD_33_I2C0_SDA,  PAD_33_FUNC0_I2C0_SDA);
  rt_pad_set_function(PAD_34_I2C0_SCL,  PAD_34_FUNC0_I2C0_SCL);
  return 0;
}

int init_gpio()
{
  // GPIO initialization
  rt_gpio_init(0, MULTIRANGER_XSHUT_UP);
  rt_gpio_init(0, MULTIRANGER_XSHUT_FRONT);
  rt_gpio_init(0, MULTIRANGER_XSHUT_LEFT);
  rt_gpio_init(0, MULTIRANGER_XSHUT_RIGHT);
  rt_gpio_init(0, MULTIRANGER_XSHUT_BACK);


   // Configure GPIO as an output
   rt_gpio_set_dir(0,(1<< MULTIRANGER_XSHUT_UP),RT_GPIO_IS_OUT);
   rt_gpio_set_dir(0,(1<< MULTIRANGER_XSHUT_FRONT),RT_GPIO_IS_OUT);
   rt_gpio_set_dir(0,(1<< MULTIRANGER_XSHUT_LEFT),RT_GPIO_IS_OUT);
   rt_gpio_set_dir(0,(1<< MULTIRANGER_XSHUT_RIGHT),RT_GPIO_IS_OUT);
   rt_gpio_set_dir(0,(1<< MULTIRANGER_XSHUT_BACK),RT_GPIO_IS_OUT);

  return 0;

}

// Inits the GPIO Pins and correct Pad assignements
void mrInit()
{
  rt_i2c_conf_t i2c_config;

  init_padframe();

  init_gpio();
  // Shut down all Chips
  rt_gpio_set_value(0, MULTIRANGER_XSHUT_ALL, 0);

  rt_i2c_conf_init(&i2c_config);

  i2c_config.id = 0;
  i2c_config.cs = 0xAA;
  i2c_config.max_baudrate = 200000;

  i2c_conf = rt_i2c_open(NULL, &i2c_config, NULL);
  if(i2c_conf == NULL)
  {
    printf("Error in I2C Device Init!\n");
  }

  //TODO this HARDCODES to use the DOWNWARD facing ToF sensor
  printf("Careful, this code only tests the downward facing ToF right now!");
  i2c_conf->cs = 0x40;
  uint8_t tx_buffer[2];
  uint8_t rx_buffer[2];
  //configure all pins as outputs
  tx_buffer[0] = 0x03;
  tx_buffer[1] = 0x00;
  rt_i2c_write(i2c_conf, tx_buffer, 2, 0, NULL);
  // write output
  tx_buffer[0] = 0x01;
  // hardcode downward facing sensor (for upwards use 0x01)
  tx_buffer[1] = 0x40;
  rt_i2c_write(i2c_conf, tx_buffer, 2, 0, NULL);
  // read back output
  tx_buffer[0] = 0x01;
  rt_i2c_write(i2c_conf, tx_buffer, 1, 0, NULL);
  rt_i2c_read(i2c_conf, rx_buffer, 1, 0, NULL);
  printf("%d read i2c outputs", rx_buffer[0]);

}

int mrTest()
{
  MULTIRANGER_XSHUT_HIGH(MULTIRANGER_XSHUT_FRONT);
  if (vl53l1xInit(&devFront, i2c_conf) == 0)
  {
      printf("Init front sensor at %#x [OK] \n", devFront.device_address);
  }
  else
  {
      printf("Init front sensor at %#x [FAIL] \n", devFront.device_address);
  }
  /*MULTIRANGER_XSHUT_HIGH(MULTIRANGER_XSHUT_LEFT);
  if (vl53l1xInit(&devLeft, i2c_conf) == 0)
  {
      printf("Init left sensor at %#x [OK] \n", devLeft.device_address);
  }
  else
  {
      printf("Init left sensor at %#x [FAIL] \n", devLeft.device_address);
  }*/
  /*MULTIRANGER_XSHUT_HIGH(MULTIRANGER_XSHUT_RIGHT);
  if (vl53l1xInit(&devRight, i2c_conf) == 0)
  {
      printf("Init right sensor at %#x [OK] \n", devRight.device_address);
  }
  else
  {
      printf("Init right sensor at %#x [FAIL] \n", devRight.device_address);
  }*/
  // MULTIRANGER_XSHUT_HIGH(MULTIRANGER_XSHUT_BACK);
  //  if (vl53l1xInit(&devBack, i2c_conf) == 0)
  //  {
  //      printf("Init back sensor at %#x [OK] \n", devBack.device_address);
  //  }
  //  else
  //  {
  //      printf("Init back sensor at %#x [FAIL] \n", devBack.device_address);
  //  }
    return 0;
}

static uint16_t mrGetMeasurementAndRestart(VL53L1_Dev_t *dev)
{
    VL53L1_Error status = VL53L1_ERROR_NONE;
    VL53L1_RangingMeasurementData_t rangingData;
    uint8_t dataReady = 0;
    uint16_t range;

    while (dataReady == 0)
    {
        status = VL53L1_GetMeasurementDataReady(dev, &dataReady);
      rt_time_wait_us(1000);
    }

    status = VL53L1_GetRangingMeasurementData(dev, &rangingData);
    range = rangingData.RangeMilliMeter;

    VL53L1_StopMeasurement(dev);
    status = VL53L1_StartMeasurement(dev);
    status = status;

    return range;
}


void mrTask()
{
  VL53L1_Error status = VL53L1_ERROR_NONE;

 // Restart all sensors
 status = VL53L1_StopMeasurement(&devFront);
 status = VL53L1_StartMeasurement(&devFront);
 //status = VL53L1_StopMeasurement(&devLeft);
 //status = VL53L1_StartMeasurement(&devLeft);
 //status = VL53L1_StopMeasurement(&devUp);
 //status = VL53L1_StartMeasurement(&devUp);
 // status = VL53L1_StopMeasurement(&devBack);
 // status = VL53L1_StartMeasurement(&devBack);
 // status = VL53L1_StopMeasurement(&devRight);
 // status = VL53L1_StartMeasurement(&devRight);
 status = status;
 printf("First Measurement started with %#02x\n", status);
 while (1)
 {
   printf("Distance: %05u\n", mrGetMeasurementAndRestart(&devFront));
   // printf("  %05u", mrGetMeasurementAndRestart(&devBack));
   //printf(" %05u\n", mrGetMeasurementAndRestart(&devLeft));
   // printf("  %05u\n", mrGetMeasurementAndRestart(&devRight));
 }

}

int main()
{
  rt_event_alloc(NULL, 64);

  mrInit();
  printf("Start Test\n");

  mrTest();

  mrTask();
    return 0;
}
